#!/bin/bash

# Demo script for interactive timer
# This demonstrates the new interactive UI feature

set -e

echo "🍅 Pomo CLI Interactive Timer Demo"
echo "===================================="
echo ""

# Check if pomo-cli is built
if [ ! -f "./pomo-cli" ]; then
    echo "Building pomo-cli..."
    go build -o pomo-cli main.go
    echo "✓ Build complete"
    echo ""
fi

# Initialize database
echo "1. Initializing database..."
./pomo-cli init
echo "✓ Database initialized"
echo ""

# Add a demo task
echo "2. Adding a demo task..."
TASK_ID=$(./pomo-cli add "Demo: Interactive Timer Test" -p 4 -d 1m -t "demo,test")
echo "✓ Task created with ID: $TASK_ID"
echo ""

# List tasks
echo "3. Listing tasks..."
./pomo-cli list
echo ""

echo "4. Starting interactive timer..."
echo ""
echo "   The timer will start in 3 seconds..."
echo "   Try these controls:"
echo "     - Press SPACE or P to pause/resume"
echo "     - Press S to stop and complete"
echo "     - Press Q to quit"
echo ""
sleep 3

# Start the timer
./pomo-cli start $TASK_ID

echo ""
echo "✓ Demo complete!"
echo ""
echo "To test with full 25-minute pomodoros:"
echo "  1. Add a task: ./pomo-cli add 'Your task' -p 4 -d 25m"
echo "  2. Start timer: ./pomo-cli start <task-id>"


