#!/bin/bash

# Pomo CLI Build and Integration Script

set -e

echo "🍅 Building Pomo CLI Integration..."

# Build the original pomo CLI
echo "📦 Building original pomo CLI..."
cd /home/shantanu/pomo
go build -o pomo ./cmd/pomo
sudo mv pomo /usr/local/bin/

# Build our integrated CLI
echo "📦 Building integrated pomo-cli..."
cd /home/shantanu/pomo-cli
go mod tidy
go build -o pomo-cli .
sudo mv pomo-cli /usr/local/bin/

# Set up environment
echo "⚙️ Setting up environment..."
cat >> ~/.bashrc << 'EOF'

# Pomo CLI Integration
export POMO_API_URL="http://localhost:3000"
export POMO_DB_PATH="$HOME/.local/share/pomo/pomo.db"

# Pomo aliases
alias pomo='pomo-cli'
alias pomo-original='/usr/local/bin/pomo'
EOF

source ~/.bashrc

# Initialize local database
echo "🗄️ Initializing local database..."
pomo-cli init

echo "✅ Build complete!"
echo ""
echo "Usage:"
echo "  pomo-cli add 'Task name'              # Add a new task"
echo "  pomo-cli list                         # List all tasks"
echo "  pomo-cli start <task-id>              # Start a pomodoro session"
echo "  pomo-cli sync-to-api                  # Sync to API server"
echo "  pomo-cli pomo list                    # Run original pomo commands"
echo ""
echo "API Server (pomo-api):"
echo "  cd /home/shantanu/pomo-api && npm start"
echo ""
echo "Environment variables:"
echo "  POMO_API_URL=$POMO_API_URL"
echo "  POMO_DB_PATH=$POMO_DB_PATH"