export type QuestionStatus = 'answered' | 'pending' | 'archived';

export interface ForumQuestion {
  id: string;
  question: string;
  answer?: string;
  module: string;
  tags: string[];
  status: QuestionStatus;
  createdAt: string;
  updatedAt?: string;
  /**
   * Public-facing name. Kept for backward compatibility with older data.
   * Should contain only the first name when exposed publicly.
   */
  askerName?: string;
  /** Stored first/last names for internal use; API should only expose first name publicly. */
  askerFirstName?: string;
  askerLastName?: string;
  askerEmail?: string;
  askerCompany?: string;
  source?: string;
  answerCount?: number;
}

export interface ForumAnswer {
  id: string;
  questionId: string;
  answer: string;
  author: string;
  authorEmail?: string;
  createdAt: string;
  isOfficial?: boolean; // For official FAQ answers
}

export interface QuestionSubmission {
  /**
   * New fields (preferred).
   */
  firstName?: string;
  lastName?: string;
  /**
   * Legacy field (older clients).
   */
  name?: string;
  email: string;
  company: string;
  module: string;
  question: string;
  source?: string;
}

export interface AnswerSubmission {
  questionId: string;
  answer: string;
  author: string;
  authorEmail?: string;
}

export interface ForumResponse<T> {
  success: boolean;
  data?: T;
  error?: string;
}

