# Repository Map - KnowBuild Corporate Website

## Overview
A Next.js 14 corporate website for KnowBuild QERP.CRM - a connected ERP+CRM system for B2B SMEs. The site features 3D graphics, dark mode, smooth scrolling, and SEO optimization.

## Tech Stack
- **Framework**: Next.js 14.2.0 (App Router)
- **Language**: TypeScript 5.8.2
- **Styling**: Tailwind CSS 3.4.3
- **3D Graphics**: Three.js, React Three Fiber, Drei
- **Animations**: Framer Motion 10.16.4
- **Smooth Scrolling**: @studio-freight/lenis
- **Charts**: Recharts 2.10.3
- **Icons**: Lucide React
- **Package Manager**: pnpm

## Directory Structure

```
knowbuildCorprateWebsite/
├── app/                          # Next.js App Router pages
│   ├── api/                      # API routes
│   │   └── forum/                # Forum API endpoints
│   │       ├── answers/route.ts
│   │       └── questions/[id]/route.ts
│   ├── book-demo/                # Book demo page
│   ├── contact/                  # Contact page
│   ├── forum/                    # Forum page
│   ├── mindset-grow-your-sme/    # Mindset content pages
│   │   └── [mindsetid]/          # Dynamic mindset page
│   ├── pricing/                  # Pricing pages
│   │   └── b2b-qerp-crm/
│   ├── privacy-policy/           # Privacy policy page
│   ├── solutions/                # Solutions pages
│   │   └── b2b-qerp-crm/
│   ├── terms-of-service/         # Terms of service page
│   ├── globals.css               # Global styles
│   ├── layout.tsx                # Root layout
│   └── page.tsx                  # Homepage
│
├── components/                   # React components
│   ├── animations/               # 3D/Animation components
│   │   ├── GradientBackground.tsx
│   │   ├── GradientBackground-blackMagic.tsx
│   │   └── LivingBackground.tsx
│   ├── common-accordion/         # Accordion component
│   ├── common-knowbuild-knowmore/
│   ├── custom-components/        # Custom reusable components
│   ├── GradientBGwithCard/       # Gradient background cards
│   ├── hooks/                    # Component-level hooks
│   │   └── usemeasure.ts
│   ├── narrative/                # Narrative section components
│   │   ├── StepCard.tsx
│   │   └── visuals/              # Visual components
│   ├── ui/                       # UI primitives (shadcn-style)
│   │   ├── badge.tsx
│   │   ├── Button.tsx
│   │   ├── card.tsx
│   │   ├── Section.tsx
│   │   ├── VideoModal.tsx
│   │   └── ZoomAwareContainer.tsx
│   ├── Benefits.tsx
│   ├── ClientLayout.tsx          # Client-side layout wrapper
│   ├── Contact.tsx
│   ├── DashboardCarousel.tsx
│   ├── FAQ.tsx
│   ├── Footer.tsx
│   ├── Header.tsx
│   ├── Hero.tsx
│   ├── Modules.tsx
│   ├── Narrative.tsx
│   ├── Narrative2.tsx
│   ├── Outcomes.tsx
│   ├── Pricing.tsx
│   ├── ProductShowcase.tsx
│   ├── RoleStrip.tsx
│   ├── SalesDashboard.tsx
│   ├── SecondBrain.tsx
│   ├── SecondBrainBanner.tsx
│   ├── SEO.tsx
│   ├── SmoothScroll.tsx
│   ├── Solutions.tsx
│   └── Trust.tsx
│
├── constants/                    # Static constants
│   └── narrativeSteps.ts
│
├── context/                      # React context providers
│   └── BackgroundContext.tsx
│
├── hooks/                        # Global custom hooks
│   ├── useSectionTheme.ts
│   └── useZoomLevel.ts
│
├── lib/                          # Utility libraries
│   ├── forum-data.ts             # Forum data utilities
│   ├── metadata.ts               # Metadata utilities
│   └── utils.ts                  # General utilities (cn, etc.)
│
├── public/                       # Static assets
│   └── (images, icons, favicon)
│
├── staticData/                   # Static data files
│   └── narrative-chapter-1-mock-data.ts
│
├── types/                        # TypeScript type definitions
│   ├── forum.ts
│   ├── theme.ts
│   ├── three-elements.d.ts
│   └── three-elements.d copy.ts
│
├── utils/                        # Utility functions
│   ├── faq-data.ts               # FAQ content
│   └── seo-config.ts             # SEO configuration
│
├── .gitignore
├── components.json               # shadcn/ui config
├── deploy.sh                     # Deployment script
├── metadata.json                 # Site metadata
├── next.config.js                # Next.js config
├── package.json
├── postcss.config.js
├── tailwind.config.js
├── tsconfig.json
└── types.ts                      # Root types
```

## Key Entry Points

### Homepage (`app/page.tsx`)
Renders main sections in order:
1. Hero
2. ProductShowcase
3. SecondBrain
4. RoleStrip
5. Narrative
6. Modules
7. Benefits
8. Pricing
9. FAQ
10. Contact

### Root Layout (`app/layout.tsx`)
- Sets up metadata, fonts, dark mode detection
- Google Analytics integration (G-9NK7RNKWDX)
- Wraps content with `ClientLayout`

### ClientLayout (`components/ClientLayout.tsx`)
- Client-side wrapper for Header/Footer
- Handles smooth scrolling with Lenis

## Scripts
- `pnpm dev` - Development server
- `pnpm build` - Production build
- `pnpm start` - Start production server
- `pnpm lint` - Run ESLint
- `pnpm deploy` - Run deploy.sh

## Notable Features
- Dark/Light mode with system detection
- 3D animated backgrounds (Three.js)
- Smooth scroll with Lenis
- Framer Motion animations
- Zoom-aware responsive components
- Forum with Q&A functionality
