import {
    MessageSquare,
    FileText,
    Truck,
    Banknote,
    Package,
    User,
    Bell,
} from 'lucide-react';

export const steps = [
    {
        id: 1,
        stage: 'capture',
        title: "Capture Inquiry",
        subtitle: "Unified Inbox",
        desc: "With automated inquiry capture from your website, real-time monitoring, smart escalation for unassigned or unattended inquiries, based on intelligent tracking — <span class='font-bold'>knowbuild ensures no inquiry ever slips through the cracks.</span>",
        icon: MessageSquare,
        color: "text-blue-400"
    },
    {
        id: 2,
        stage: 'qualify',
        title: "Qualify & Assign",
        subtitle: "Smart Routing",
        desc: "Smart Inquiry assignment routes inquiries to the right salesperson based on pre-defined rules — ensuring faster, efficient and disciplined follow-ups.",
        icon: User,
        color: "text-indigo-400"
    },
    {
        id: 3,
        stage: 'quote',
        title: "Quote & Approve",
        subtitle: "Precision Pricing",
        desc: "Sales Quotes with Intelligence  Win more deals with end-to-end visibility from inquiry to closure. Sell smarter with predefined discount controls that empower your sales team to close orders without manager intervention. ",
        icon: FileText,
        color: "text-violet-400"
    },
    {
        id: 4,
        stage: 'purchase',
        title: "Purchase & Stock",
        subtitle: "Inventory AI",
        desc: "Smart Purchase Alerts that provide automatic re-order notifications with data-driven purchase forecasts – ensures that you never overstock and always have what your customers need.",
        icon: Package,
        color: "text-fuchsia-400"
    },
    {
        id: 5,
        stage: 'dispatch',
        title: "Dispatch & Invoice",
        subtitle: "Logistics Flow",
        desc: "From sales order → scan → pack,  <span className='font-bold'> UPC </span>-based scanning ensures 100% error-free dispatches. Generate <span className='font-bold'>e-invoices</span> and <span className='font-bold'>e-way bills</span> instantly through the GST portal with seamless integration. Scan-to-pack validation ensures 100% accuracy. Generate the E-Way bill and Invoice instantly.",
        icon: Truck,
        color: "text-emerald-400"
    },
    {
        id: 6,
        stage: 'cash',
        title: "Get Paid",
        subtitle: "Revenue Cycle",
        desc: "Accounts receivable tracking, automated reminders, and tight connectivity between finance and sales ensure you collect payments faster — and grow your business with confidence. ",
        icon: Banknote,
        color: "text-green-400"
    },
    {
        id: 7,
        stage: 'messaging',
        title: "Messaging Automation",
        subtitle: "Command Center",
        desc: "knowbuild keeps your teams on track — so nothing is missed. Automated alerts for Sales, Finance, and Operations ensure critical tasks are handled instantly.",
        icon: Bell,
        color: "text-cyan-400"
    }
] as const;
