'use client';

import React, { useState, useEffect } from 'react';

export const CountUp = ({ end }: { end: number }) => {
    const [count, setCount] = useState(0);
    useEffect(() => {
        let start = 0;
        const duration = 2000;
        const step = (timestamp: number) => {
            if (!start) start = timestamp;
            const progress = Math.min((timestamp - start) / duration, 1);
            setCount(Math.floor(progress * end));
            if (progress < 1) window.requestAnimationFrame(step);
        };
        window.requestAnimationFrame(step);
    }, [end]);
    return <span>₹ {(count / 1000).toFixed(1)}k</span>;
};
