import React from 'react';

export const CardShell = ({ children, className = "" }: { children: React.ReactNode; className?: string }) => (
    <div className={`relative w-full max-w-md bg-white/60 dark:bg-slate-900/60 backdrop-blur-xl border border-white/40 dark:border-slate-700/40 rounded-3xl shadow-xl dark:shadow-[0_0_40px_-10px_rgba(0,0,0,0.5)] overflow-hidden ${className}`}>
        <div className="absolute inset-0 pointer-events-none border border-white/20 rounded-3xl" />
        {children}
    </div>
);
