'use client';

import React from 'react';
import { motion } from 'framer-motion';
import { steps } from '../../constants/narrativeSteps';
import { CaptureVisual } from './visuals/CaptureVisual';
import { QualifyVisual } from './visuals/QualifyVisual';
import { QuoteVisual } from './visuals/QuoteVisual';
import { PurchaseVisual } from './visuals/PurchaseVisual';
import { DispatchVisual } from './visuals/DispatchVisual';
import { CashVisual } from './visuals/CashVisual';
import { MessagingVisual } from './visuals/MessagingVisual';

export const StepCard = ({ step, index, isActive, onActivate }: { step: typeof steps[number], index: number, isActive: boolean, onActivate: () => void }) => {
    return (
        <motion.div
            className={`min-h-[500px] md:min-h-[600px] lg:min-h-[700px] flex items-center justify-center lg:justify-start transition-all duration-300 ${isActive ? 'opacity-100 translate-x-0' : 'opacity-30 translate-x-0 md:translate-x-4 blur-[2px]'}`}
        >
            <div className="relative max-w-lg">
                <div className="flex items-center gap-4 mb-6">
                    <span className="font-mono text-xs text-slate-400 dark:text-slate-500 uppercase tracking-widest">0{index + 1}</span>
                    <div className={`h-px w-12 ${isActive ? 'bg-slate-900 dark:bg-white' : 'bg-slate-300 dark:bg-slate-700'} transition-colors duration-300`} />
                    <span className={`font-mono text-xs uppercase tracking-widest ${isActive ? 'text-slate-900 dark:text-white' : 'text-slate-400 dark:text-slate-500'} transition-colors duration-300`}>
                        {step.subtitle}
                    </span>
                </div>

                {/* Mask Reveal Title */}
                <div className="overflow-hidden mb-6">
                    <motion.h3
                        initial={{ y: "100%" }}
                        animate={{ y: isActive ? 0 : "100%" }}
                        transition={{ duration: 0.4, ease: [0.25, 0.1, 0.25, 1] }}
                        className="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-bold text-slate-900 dark:text-white leading-[0.9] tracking-tighter"
                    >
                        {step.title}
                    </motion.h3>
                </div>

                <motion.div
                    initial={{ opacity: 0 }}
                    animate={{ opacity: isActive ? 1 : 0.5 }}
                    transition={{ duration: 0.3 }}
                    className="text-base sm:text-lg md:text-xl text-slate-600 dark:text-slate-400 leading-relaxed max-w-md"
                >
                    <div
                        dangerouslySetInnerHTML={{
                            __html: (step.desc ?? '').replaceAll('className=', 'class='),
                        }}
                    />
                </motion.div>

                {/* Mobile Visual */}
                <div className="lg:hidden mt-12 w-full flex justify-center transform scale-90">
                    {step.stage === 'capture' && <CaptureVisual />}
                    {step.stage === 'qualify' && <QualifyVisual />}
                    {step.stage === 'quote' && <QuoteVisual />}
                    {step.stage === 'purchase' && <PurchaseVisual />}
                    {step.stage === 'dispatch' && <DispatchVisual />}
                    {step.stage === 'cash' && <CashVisual />}
                    {step.stage === 'messaging' && <MessagingVisual />}
                </div>
            </div>
        </motion.div>
    );
};
