import Link from 'next/link';
import * as React from 'react';
import { Button } from '../ui/Button';



export function KnowmoreCommonButtons() {
  return (
    <div className="flex flex-col sm:flex-row items-center justify-center gap-4">
      <Link href="/book-demo" className="w-full sm:w-auto">
        <Button size="lg" fullWidth className="min-w-[220px]">
          Book a Demo
        </Button>
      </Link>
      <Link href="/contact" className="w-full sm:w-auto">
        <Button size="lg" variant="outline" fullWidth className="min-w-[220px]">
          Talk to Us
        </Button>
      </Link>
    </div>
  );
}











