import * as React from 'react';

type AccordionItem = {
  question: string;
  answer: string;
};

const DEFAULT_ITEMS: AccordionItem[] = [
  {
    question: 'What is KnowBuild?',
    answer:
      'KnowBuild is a workflow-first QERP.CRM designed for growing B2B SMEs—connecting inquiry-to-cash across sales, operations, and finance.',
  },
  {
    question: 'How quickly can we go live?',
    answer:
      'Most SMEs can go live in 2–4 weeks with guided setup and data migration support (customers, products, opening balances).',
  },
  {
    question: 'Is it only a CRM?',
    answer:
      'No—CRM is the starting point. KnowBuild ties quoting, procurement, dispatch, invoicing, and receivables into one connected system.',
  },
  {
    question: 'Can we roll it out in phases?',
    answer:
      'Yes. Start with sales workflows and progressively enable operations and finance modules when the team is ready.',
  },
  {
    question: 'Does it work with existing accounting tools?',
    answer:
      'KnowBuild manages invoicing and receivables and provides exportable reports compatible with common accounting tools for ledger posting.',
  },
];

export default function AccordionCommon({ items = DEFAULT_ITEMS }: { items?: AccordionItem[] }) {
  return (
    <div className="mx-auto max-w-4xl space-y-3">
      {items.map((item, idx) => (
        <details
          key={idx}
          className={[
            'group rounded-2xl border border-slate-200/70 bg-white/70 p-5 shadow-sm backdrop-blur',
            'dark:border-slate-800/70 dark:bg-slate-900/40',
          ].join(' ')}
        >
          <summary className="cursor-pointer list-none select-none text-lg font-semibold text-brand-navy dark:text-white">
            <div className="flex items-center justify-between gap-4">
              <span>{item.question}</span>
              <span className="text-slate-400 transition-transform duration-200 group-open:rotate-45">+</span>
            </div>
          </summary>
          <div className="mt-3 text-slate-600 dark:text-slate-300 leading-relaxed">{item.answer}</div>
        </details>
      ))}
    </div>
  );
}











