
import React from 'react';
import { Section } from './ui/Section';
import { GitCommit, Users, BarChart3 } from 'lucide-react';

const cards = [
  {
    title: "Standardize",
    desc: "Embed SOPs into your tool. New hires follow the right process from Day 1.",
    icon: GitCommit
  },
  {
    title: "Democratize",
    desc: "Built-in rules for credit & discounts let teams move fast without constant approval loops.",
    icon: Users
  },
  {
    title: "Scale",
    desc: "Unlock 2-3x revenue growth with dashboards that highlight bottlenecks instantly.",
    icon: BarChart3
  }
];

export const Outcomes: React.FC = () => {
  return (
    <Section id="outcomes">
      <div className="max-w-3xl mx-auto text-center mb-16">
        <h2 className="text-3xl font-bold text-brand-navy dark:text-white mb-4">
          Built to help you grow 2-3x
        </h2>
        <p className="text-lg text-slate-600 dark:text-slate-300">
          Don't just manage data. Codify your knowledge into a system that scales.
        </p>
      </div>

      <div className="grid md:grid-cols-3 gap-8 mb-20">
        {cards.map((card, i) => (
          <div key={i} className="flex flex-col items-center text-center p-6">
            <div className="w-16 h-16 bg-blue-50 dark:bg-slate-800 text-brand-navy dark:text-white rounded-full flex items-center justify-center mb-6 shadow-sm">
              <card.icon size={32} />
            </div>
            <h3 className="text-xl font-bold text-brand-navy dark:text-white mb-3">{card.title}</h3>
            <p className="text-slate-600 dark:text-slate-400">{card.desc}</p>
          </div>
        ))}
      </div>

      <div className="bg-brand-navy dark:bg-slate-800 rounded-2xl p-8 md:p-12 text-white shadow-2xl border border-slate-800 dark:border-slate-700">
        <div className="grid md:grid-cols-3 gap-8 text-center divide-y md:divide-y-0 md:divide-x divide-slate-800 dark:divide-slate-700">
          <div>
            <div className="text-4xl md:text-5xl font-bold text-emerald-400 mb-2">2.5x</div>
            <p className="text-slate-300 text-sm uppercase tracking-wide">Avg. Growth Achieved</p>
          </div>
          <div className="pt-8 md:pt-0">
            <div className="text-4xl md:text-5xl font-bold text-emerald-400 mb-2">500+</div>
            <p className="text-slate-300 text-sm uppercase tracking-wide">Active SME Teams</p>
          </div>
          <div className="pt-8 md:pt-0">
            <div className="text-4xl md:text-5xl font-bold text-emerald-400 mb-2">40%</div>
            <p className="text-slate-300 text-sm uppercase tracking-wide">Efficiency Gain</p>
          </div>
        </div>
        <p className="text-center text-slate-400 text-xs mt-8 opacity-70">Based on typical customer results. Outcomes may vary.</p>
      </div>
    </Section>
  );
};
