'use client';

import React from 'react';
import { Section } from './ui/Section';
import { 
  PhoneIncoming, 
  FileText, 
  CreditCard, 
  ShoppingCart, 
  Package, 
  Truck, 
  ScrollText, 
  HeadphonesIcon
} from 'lucide-react';
import { motion } from 'framer-motion';

const modules = [
  {
    title: "Inbound Sales",
    focus: "Capture inquiries from all sources.",
    benefit: "Zero leakage. Every lead tracked.",
    icon: PhoneIncoming,
    color: "text-brand-blue",
    bg: "bg-brand-blue/5 dark:bg-brand-blue/10",
    span: "md:col-span-1"
  },
  {
    title: "Sales CRM",
    focus: "Quotes, negotiations & follow-ups.",
    benefit: "Auto-assign deals & track history.",
    icon: FileText,
    color: "text-brand-orange",
    bg: "bg-brand-orange/5 dark:bg-brand-orange/10",
    span: "md:col-span-1 lg:col-span-2"
  },
  {
    title: "Finance & Credit",
    focus: "Receivables, limits & approvals.",
    benefit: "Stop chasing payments manually.",
    icon: CreditCard,
    color: "text-brand-teal",
    bg: "bg-brand-teal/5 dark:bg-brand-teal/10",
    span: "md:col-span-1"
  },
  {
    title: "Procurement",
    focus: "Planning & vendor orders.",
    benefit: "Smart PO suggestions based on sales.",
    icon: ShoppingCart,
    color: "text-purple-600 dark:text-purple-400",
    bg: "bg-purple-50 dark:bg-purple-900/20",
    span: "md:col-span-1"
  },
  {
    title: "Warehousing",
    focus: "Real-time stock movement.",
    benefit: "Avoid stock-outs & dead inventory.",
    icon: Package,
    color: "text-indigo-600 dark:text-indigo-400",
    bg: "bg-indigo-50 dark:bg-indigo-900/20",
    span: "md:col-span-1"
  },
  {
    title: "Dispatch",
    focus: "Delivery planning & accuracy.",
    benefit: "100% correct item dispatch.",
    icon: Truck,
    color: "text-rose-600 dark:text-rose-400",
    bg: "bg-rose-50 dark:bg-rose-900/20",
    span: "md:col-span-1 lg:col-span-2"
  },
  {
    title: "Tendering",
    focus: "Govt & institutional tenders.",
    benefit: "Never miss a submission deadline.",
    icon: ScrollText,
    color: "text-amber-600 dark:text-amber-400",
    bg: "bg-amber-50 dark:bg-amber-900/20",
    span: "md:col-span-1",
    optional: true // mark as optional
  },
  {
    title: "Service & Support",
    focus: "Tickets, SLAs & complaints.",
    benefit: "Happy customers, faster resolution.",
    icon: HeadphonesIcon,
    color: "text-emerald-600 dark:text-emerald-400",
    bg: "bg-emerald-50 dark:bg-emerald-900/20",
    span: "md:col-span-1",
    optional: true // mark as optional
  }
];

export const Modules: React.FC = () => {
  return (
    <Section id="modules" theme="solutions">
      <div className="text-center max-w-3xl mx-auto mb-16">
        <motion.span 
          initial={{ opacity: 0 }}
          whileInView={{ opacity: 1 }}
          className="inline-block text-brand-orange font-bold tracking-wider uppercase text-xs mb-3 px-3 py-1 rounded-full bg-brand-orange/10 border border-brand-orange/20"
        >
          Power Packed
        </motion.span>
        <h2 className="text-4xl md:text-5xl font-bold text-brand-navy dark:text-white mb-6 tracking-tight">
          Every core module your SME needs. <br/>
          <span className="text-brand-blue dark:text-brand-lightBlue">Built-in from day one.</span>
        </h2>
        <p className="text-lg text-slate-600 dark:text-slate-300 max-w-2xl mx-auto">
          Forget paying for "extra modules" or "plugins". 
          knowbuild gives you the full stack to run your business instantly.
        </p>
      </div>

      {/* Bento Grid Layout */}
      <div className="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4 auto-rows-[minmax(240px,auto)]">
        {modules.map((mod, i) => (
          <motion.div 
            key={i}
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ delay: i * 0.05 }}
            className={`
              group relative p-8 rounded-3xl border border-white/40 dark:border-white/5 shadow-sm hover:shadow-xl transition-all duration-500
              backdrop-blur-md bg-white/40 dark:bg-slate-900/40 ${mod.span || 'col-span-1'} flex flex-col justify-between overflow-hidden
            `}
          >
            {/* Hover Gradient Background */}
            <div className={`absolute inset-0 opacity-0 group-hover:opacity-100 transition-opacity duration-500 ${mod.bg}`} />

            <div className="relative z-10">
              <div className="flex justify-between items-start mb-6">
                <div className={`w-12 h-12 rounded-2xl flex items-center justify-center ${mod.bg} ${mod.color} border border-white/50 dark:border-white/10 shadow-inner`}>
                  <mod.icon size={24} />
                </div>
                {/* Optional badge */}
                {mod.optional && (
                  <span className="ml-2 bg-orange-600 px-2 py-0.5 text-xs font-semibold rounded-full text-white dark:bg-slate-800  dark:text-slate-300 border border-slate-200 dark:border-slate-700">
                    Optional
                  </span>
                )}
              </div>
              
              <h3 className="text-xl font-bold text-brand-navy dark:text-white mb-2 group-hover:text-brand-blue dark:group-hover:text-brand-lightBlue transition-colors">{mod.title}</h3>
              <p className="text-slate-500 dark:text-slate-400 text-sm font-medium mb-4">{mod.focus}</p>
            </div>

            <div className="relative z-10 mt-auto pt-4 border-t border-slate-100/50 dark:border-slate-700/50">
              <p className="text-slate-700 dark:text-slate-300 text-sm font-semibold leading-relaxed group-hover:translate-x-1 transition-transform duration-300">
                {mod.benefit}
              </p>
            </div>
          </motion.div>
        ))}
      </div>
    </Section>
  );
};
