'use client';

import React, { useCallback, useRef } from 'react';
import { Button } from './ui/Button';
import { Play, Zap, CheckCircle2, Bell, TrendingUp, AlertCircle } from 'lucide-react';
import { motion } from 'framer-motion';
import { useSectionTheme } from '../hooks/useSectionTheme';

const download2VideoSrc = new URL('../lib/download (20).mp4', import.meta.url).href;
const darkVideoSrc = new URL('../lib/download (22).mp4', import.meta.url).href;
// Unused preview images
// const transparentPreviewSrc = new URL('../lib/transparentvideo image.png', import.meta.url).href;
// const darkPreviewSrc = new URL('../lib/transparentdark.png', import.meta.url).href;

// Data commented out as we are using images for both light and dark modes
// const data = [
//   { name: 'Mon', leads: 4 },
//   { name: 'Tue', leads: 7 },
//   { name: 'Wed', leads: 5 },
//   { name: 'Thu', leads: 12 },
//   { name: 'Fri', leads: 9 },
//   { name: 'Sat', leads: 6 },
// ];

export const Hero: React.FC = () => {
  const themeRef = useSectionTheme('hero');
  const hoverVideoRef = useRef<HTMLVideoElement | null>(null);
  const darkHoverVideoRef = useRef<HTMLVideoElement | null>(null);
  const openProductShowcase = useCallback((e: React.MouseEvent<HTMLAnchorElement>) => {
    e.preventDefault();
    const el = document.getElementById('product-showcase');
    if (el) {
      el.scrollIntoView({ behavior: 'smooth', block: 'start' });
    }
    // Keep the URL shareable/deeplinkable.
    window.history.replaceState(null, '', '#product-showcase');
    // Open the modal after the scroll has started.
    window.setTimeout(() => {
      window.dispatchEvent(new CustomEvent('productShowcase:openVideo'));
    }, 650);
  }, []);

  const startHoverVideo = useCallback(() => {
    const video = hoverVideoRef.current;
    if (!video) return;
    try {
      video.currentTime = 0;
    } catch {
      // ignore
    }
    video.play().catch(() => {
      // Autoplay can still be blocked in some environments; hover/focus should usually allow it.
    });
  }, []);

  const stopHoverVideo = useCallback(() => {
    // No-op to keep video playing
  }, []);

  const startDarkHoverVideo = useCallback(() => {
    const video = darkHoverVideoRef.current;
    if (!video) return;
    try {
      video.currentTime = 0;
    } catch {
      // ignore
    }
    video.play().catch(() => {
      // Autoplay can still be blocked in some environments; hover/focus should usually allow it.
    });
  }, []);

  const stopDarkHoverVideo = useCallback(() => {
    // No-op to keep video playing
  }, []);

  return (
    <section ref={themeRef} className="relative pt-24 pb-20 md:pt-30 md:pb-1 overflow-hidden">
      {/* Ambient Background Glows */}
      {/* <div className="absolute top-0 left-1/2 -translate-x-1/2 w-[1000px] h-[1000px] bg-gradient-radial from-brand-blue/10 dark:from-brand-blue/5 to-transparent rounded-full blur-3xl -z-10 opacity-60 pointer-events-none" />
      <div className="absolute bottom-0 right-0 w-[800px] h-[800px] bg-brand-teal/5 dark:bg-brand-teal/5 rounded-full blur-3xl -z-10 pointer-events-none" /> */}

      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div className="grid lg:grid-cols-2 gap-16 lg:gap-20 items-center">

          {/* Left Content */}
          <motion.div
            initial={{ opacity: 0, x: -50 }}
            animate={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8, ease: "easeOut" }}
            className="max-w-2xl"
          >
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.2 }}
              className="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-white/60 dark:bg-white/10 backdrop-blur-sm border border-brand-blue/20 dark:border-white/10 text-brand-blue dark:text-brand-lightBlue text-xs font-bold uppercase tracking-wide mb-8 shadow-sm"
            >
              <span className="relative flex h-2.5 w-2.5">
                <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-brand-blue opacity-75"></span>
                <span className="relative inline-flex rounded-full h-2.5 w-2.5 bg-brand-blue"></span>
              </span>
             Incredibly powerful
            </motion.div>

            <h1 className="hero-title">
              QERP.CRM <br />
              <span className="hero-title-span">The Operating System For <br />Growing SMEs</span>
            </h1>

            <div className="text-2xl text-slate-700 dark:text-slate-200 mb-4 leading-relaxed max-w-lg font-extrabold">
              {/* <div className="font-extrabold text-2xl text-transparent bg-clip-text bg-gradient-to-r from-amber-500 via-orange-500 to-rose-500 animate-gradient-x drop-shadow-[0_0_15px_rgba(251,146,60,0.5)] mb-2"> QERP + CRM built for growing SMEs</div> */}
              One system to automate and systemise your operations
              from sales to cash, procurement to delivery, and invoicing to collections
            </div>
            <div className="flex items-center gap-6 text-sm font-medium text-slate-500 dark:text-slate-400 border-t border-slate-200/60 dark:border-white/10 pt-1 mb-8">
              {["No hidden modules", "1-2 Week Go-Live","Built for India"].map((item, i) => (
                <div key={i} className="flex items-center gap-2">
                  <CheckCircle2 className="text-brand-teal w-5 h-5" />
                  <span>{item}</span>
                </div>
              ))}
            </div>
            <div className="flex flex-col sm:flex-row gap-4 mb-10">
              <a href="/book-demo">
                <Button size="lg" variant="primary" icon={<Zap size={20} />}>
                  Book a Live Demo
                </Button>
              </a>
              {/* Light mode: custom 3D-ish CTA button. Dark mode: keep existing outline button. */}
              {/* <a href="#product-showcase" onClick={openProductShowcase} className="btn-container dark:hidden">
                <div className="btn-back" />
                <div className="btn-front">
                  
                  <p>See it in action</p>
                  <svg
                    width="24px"
                    height="24px"
                    viewBox="0 0 16 16"
                    xmlns="http://www.w3.org/2000/svg"
                    fill="none"
                    aria-hidden="true"
                    focusable="false"
                  >
                    <g fill="currentColor">
                      <path d="M8 2.5a5.494 5.494 0 00-4.558 2.42.75.75 0 01-1.242-.84 7 7 0 110 7.841.75.75 0 111.242-.841A5.5 5.5 0 108 2.5z" />
                      <path d="M7.245 4.695a.75.75 0 00-.05 1.06l1.36 1.495H1.75a.75.75 0 000 1.5h6.805l-1.36 1.495a.75.75 0 001.11 1.01l2.5-2.75a.75.75 0 000-1.01l-2.5-2.75a.75.75 0 00-1.06-.05z" />
                    </g>
                  </svg>
                  
                </div>
              </a> */}
              <a href="#product-showcase" onClick={openProductShowcase} className="inline-block">
                <Button
                  variant="outline"
                  size="lg"
                  icon={<Play size={20} className="text-blue-600 dark:text-sky-300" />}
                  className="text-blue-600"
                >
                  See it in action
                </Button>
              </a>
            </div>

         
          </motion.div>

          {/* Right Visual - Floating Tilted Dashboard */}
          <motion.div
            initial={{ opacity: 0, scale: 0.8, rotateY: -20, rotateX: 10 }}
            animate={{ opacity: 1, scale: 1, rotateY: -10, rotateX: 5 }}
            transition={{ duration: 1.2, type: "spring", bounce: 0.4 }}
            className="relative perspective-1000 h-[700px]  items-center justify-center hidden lg:flex"
          >
            {/* Abstract BG Decoration */}
            <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[80%] h-[80%] bg-gradient-radial from-brand-blue/20 to-transparent blur-[60px] -z-10"></div>

            <motion.div
              initial={{ opacity: 0, rotateY: -18, rotateX: 6, scale: 0.86 }}
              animate={{ opacity: 1, rotateY: -12, rotateX: 3, scale: 1 }}
              transition={{
                duration: 1.5,
                type: "spring",
                bounce: 0.4,
                delay: 0.1,
              }}
              className="relative w-full h-full flex items-center justify-center"
              style={{ perspective: 1500 }}
            >
              <div className="origin-center scale-[0.4] sm:scale-[0.5] md:scale-[0.65] w-[1000px]">
                <div className=" w-[60vw]  rounded-2xl overflow-hidden ">
                  {/* // Light mode: static PNG → hover plays video */}
                  <div className="block dark:hidden">
                    <div className="relative w-full">
                      <video
                        ref={hoverVideoRef}
                        className="w-full h-full object-cover object-center"
                        src={download2VideoSrc}
                        loop
                        muted
                        playsInline
                        autoPlay
                        preload="metadata"
                        aria-label="Knowbuild product demo video"
                      />
                    </div>
                  </div>
                  <div className="hidden dark:block">
                    <div className="relative w-full">
                      <video
                        ref={darkHoverVideoRef}
                        className="w-full h-full object-cover object-center"
                        src={darkVideoSrc}
                        loop
                        muted
                        playsInline
                        autoPlay
                        preload="metadata"
                        aria-label="Knowbuild product demo video"
                      />
                    </div>
                  </div>
                </div>
              </div>
            </motion.div>
          </motion.div>
        </div>
      </div>
    </section>
  );
};
