'use client';

import React, { useState } from 'react';
import Link from 'next/link';
import { Section } from './ui/Section';
import { ChevronDown, ChevronUp, ArrowRight } from 'lucide-react';
import { Button } from './ui/Button';

const faqs = [
  {
    question: "Is knowbuild a SaaS product or available as outright purchase?",
    answer: (
      <>
        <p><strong>knowbuild is a SaaS product.</strong></p>
        <p>
          We do not offer an outright purchase option because our team works continuously to improve the platform with new features, updates, and performance enhancements — all of which become available to you at no additional cost under the SaaS model.
        </p>
        <p>
          This ensures your system keeps improving every month without expensive upgrades or migrations. This is why we don't offer an outright purchase option.
        </p>
      </>
    )
  },
  {
    question: "Why is knowbuild called a QERP.CRM?",
    answer: (
      <>
        <p><strong>QERP</strong> stands for <strong>“Quasi-ERP”</strong> — an ERP-level operating system designed specifically for SMEs, with CRM built in at the core.</p>
        <p>
          Unlike traditional ERPs built for large enterprises, QERP is:
        </p>
        <ul className="list-disc pl-6 mb-2">
          <li>Lightweight yet powerful</li>
          <li>Fast to implement</li>
          <li>Built around the inquiry-to-cash workflow</li>
          <li>Integrated deeply with CRM, operations, dispatch & finance</li>
        </ul>
        <p>
          “QERP.CRM” simply means:
        </p>
        <p>
          A connected ERP + CRM system tailor-made for real-world SME teams, that provides ERP + CRM + automation + dispatch + intelligence — exactly what “Quasi-ERP” suggests.
        </p>
      </>
    )
  },
  {
    question: "How is knowbuild different from generic ERPs?",
    answer: "Generic ERPs are often bloated and hard to use. knowbuild is purpose-built exclusively for B2B SMEs, focusing specifically on the inquiry-to-cash cycle. It connects sales directly to operations and finance, systemizing your company from Day 1 — without the complexity of large enterprise systems and light-years ahead of basic accounting tools or generic CRM/ERP software in the market. "
  },
  {
    question: "How long does implementation take?",
    answer: "For a typical SME, we aim for a 2-4 week Go-Live. Our team helps migrate your customer and product data so you can start quoting and billing quickly."
  },
  {
    question: "Can we start with just CRM and add operations later?",
    answer: "Yes. While knowbuild is a unified system, you can roll it out in phases. Start by fixing your sales funnel, then unlock procurement and dispatch when the team is ready."
  },
  {
    question: "Does it integrate with accounting software?",
    answer: "knowbuild handles all invoicing and receivables management. We provide exportable reports compatible with major accounting tools like Tally or QuickBooks for final ledger posting."
  }
];

export const FAQ: React.FC = () => {
  const [openIndex, setOpenIndex] = useState<number | null>(null);

  return (
    <Section bgColor="light" theme="contact">
      <div className="max-w-3xl mx-auto">
        <h2 className="text-3xl font-bold text-brand-navy dark:text-white mb-8 text-center">Frequently Asked Questions</h2>
        <div className="space-y-4 mb-8">
          {faqs.map((faq, i) => (
            <div key={i} className="bg-white/50 dark:bg-slate-800/50 backdrop-blur-sm rounded-lg border border-white/60 dark:border-slate-700/50 overflow-hidden">
              <button 
                className="w-full px-6 py-4 text-left flex justify-between items-center focus:outline-none group"
                onClick={() => setOpenIndex(openIndex === i ? null : i)}
              >
                <span className="font-semibold text-brand-navy dark:text-slate-100 group-hover:text-brand-blue dark:group-hover:text-brand-lightBlue transition-colors">{faq.question}</span>
                {openIndex === i ? <ChevronUp className="text-brand-blue" /> : <ChevronDown className="text-slate-400" />}
              </button>
              {openIndex === i && (
                <div className="px-6 pb-4 text-slate-600 dark:text-slate-300 text-sm leading-relaxed">
                  {faq.answer}
                </div>
              )}
            </div>
          ))}
        </div>
        <div className="text-center">
          <Link href="/forum">
            <Button variant="primary" size="lg">
              View All Questions & Ask Your Own
              <ArrowRight className="ml-2 h-4 w-4" />
            </Button>
          </Link>
        </div>
      </div>
    </Section>
  );
};
