'use client';

import React from 'react';
import { Section } from './ui/Section';
import { Zap, Settings } from 'lucide-react';
import { motion } from 'framer-motion';

export const Benefits: React.FC = () => {
  return (
    <Section bgColor="light" id="use-cases" theme="mindset">
      <div className="grid lg:grid-cols-2 gap-8 lg:gap-12">
        
        {/* Column A */}
        <motion.div 
          whileHover={{ y: -5 }}
          className="bg-white/60 dark:bg-slate-800/60 backdrop-blur-lg p-8 md:p-10 rounded-[2rem] shadow-sm hover:shadow-xl border border-white/60 dark:border-slate-700/50 transition-all duration-300"
        >
          <div className="flex items-center gap-4 mb-8">
            <div className="p-3 bg-blue-50 dark:bg-blue-900/30 text-brand-blue dark:text-blue-400 rounded-2xl shadow-inner">
              <Zap size={28} />
            </div>
            <h3 className="text-2xl md:text-3xl font-bold text-brand-navy dark:text-white tracking-tight">Sell faster, <br/>fewer mistakes</h3>
          </div>
          <ul className="space-y-5">
            {[
              "Centralized Quote Library: Search, edit, and resend any past quote in seconds.",
              "Instant Revisions: Update pricing during negotiations without starting over.",
              "Smart Categorization: Find the right product among thousands instantly.",
              "Dispatch Link: Quotes link to unique part codes—no more wrong shipments.",
              "Discount Guardrails: Sales teams offer competitive prices within set limits."
            ].map((item, i) => (
              <li key={i} className="flex gap-4 text-slate-600 dark:text-slate-300 items-start">
                <span className="w-2 h-2 rounded-full bg-brand-blue mt-2.5 flex-shrink-0 shadow-[0_0_10px_rgba(0,82,204,0.5)]"></span>
                <span className="leading-relaxed font-medium">{item}</span>
              </li>
            ))}
          </ul>
        </motion.div>

        {/* Column B */}
        <motion.div 
          whileHover={{ y: -5 }}
          className="bg-white/60 dark:bg-slate-800/60 backdrop-blur-lg p-8 md:p-10 rounded-[2rem] shadow-sm hover:shadow-xl border border-white/60 dark:border-slate-700/50 transition-all duration-300"
        >
          <div className="flex items-center gap-4 mb-8">
            <div className="p-3 bg-emerald-50 dark:bg-emerald-900/30 text-emerald-600 dark:text-emerald-400 rounded-2xl shadow-inner">
              <Settings size={28} />
            </div>
            <h3 className="text-2xl md:text-3xl font-bold text-brand-navy dark:text-white tracking-tight">Operations on <br/>Autopilot</h3>
          </div>
          <ul className="space-y-5">
            {[
              "Instant Credit Checks: See receivables & history before approving new orders.",
              "Auto-Notifications: Sales gets alerted immediately when payment arrives.",
              "Warranty Lookup: Serial number tracking removes guesswork.",
              "Marketing ROI: Track inbound inquiries by source and conversion quality.",
              "One-Click Invoicing: Generate compliant digital invoices directly from dispatch."
            ].map((item, i) => (
              <li key={i} className="flex gap-4 text-slate-600 dark:text-slate-300 items-start">
                <span className="w-2 h-2 rounded-full bg-emerald-500 mt-2.5 flex-shrink-0 shadow-[0_0_10px_rgba(16,185,129,0.5)]"></span>
                <span className="leading-relaxed font-medium">{item}</span>
              </li>
            ))}
          </ul>
        </motion.div>

      </div>
    </Section>
  );
};
