"use client";

import { motion } from "framer-motion";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { cn } from "@/lib/utils";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/Button";
import Image from "next/image";
import { ArrowUp } from "lucide-react";

const container = {
  hidden: { opacity: 0 },
  show: {
    opacity: 1,
    transition: {
      staggerChildren: 0.08,
      delayChildren: 0.12,
      when: "beforeChildren",
    },
  },
};

const item = {
  hidden: { opacity: 0, y: 16 },
  show: { opacity: 1, y: 0 },
};

const sections = [
  { id: "info-we-collect", title: "1. Information We Collect" },
  { id: "use-of-information", title: "2. Purpose and Use of Information" },
  { id: "data-retention", title: "3. Data Retention" },
  { id: "data-sharing", title: "4. Data Sharing and Disclosure" },
  { id: "security-practices", title: "5. Security Practices" },
  { id: "user-rights", title: "6. User Rights" },
  { id: "grievance-officer", title: "7. Grievance Officer" },
  { id: "policy-updates", title: "8. Policy Updates" },
  { id: "contact", title: "9. Contact" },
];

export function PrivacyPolicyContent() {
  return (
    <div className="container mx-auto px-4 py-10 md:py-16 pt-32">
      <motion.header
        initial={{ opacity: 0, y: 12 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.4, ease: "easeOut" }}
        className="mb-8 md:mb-12 w-[80%] md:w-[60%] lg:w-[50%] mx-auto text-center"
      >
        <Badge className="mb-3 w-fit">
          {/* <span className="inline-flex items-center rounded-full bg-slate-100 dark:bg-slate-800 px-3 py-1 text-xs md:text-sm text-slate-900 dark:text-slate-50"> */}
          Privacy Policy
          {/* </span> */}
        </Badge>
        <div className="text-brand-blue text-3xl flex flex-col md:flex-row items-center justify-center gap-x-3 gap-y-2 font-bold font-stretch-50% tracking-tight md:text-4xl">
          <h1>Privacy Policy —</h1>
          <div className="p-2 rounded-lg">
             <Image
                src={"https://knowbuildwebsiteassets.s3.ap-south-1.amazonaws.com/logo.svg"}
                alt="knowbuild_logo_privacy_policy_page"
                height={40}
                width={150}
                className="h-10 w-auto"
            />
          </div>
        </div>
        <p className="mt-2 text-sm text-slate-500 dark:text-slate-400 md:text-base">
          Last Updated: October 2025
        </p>
      </motion.header>

      <div className="grid gap-8 md:grid-cols-12">
        {/* Table of contents */}
        <motion.nav
          initial={{ opacity: 0, y: 12 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.4, ease: "easeOut", delay: 0.05 }}
          aria-label="Table of contents"
          className="md:col-span-4 lg:col-span-3 order-2 md:order-1"
        >
          <Card className="sticky top-24">
            <CardHeader className="pb-4">
              <CardTitle className="text-base">On this page</CardTitle>
            </CardHeader>
            <CardContent className="flex flex-col gap-2 pb-5 text-sm">
              {sections.map((s) => (
                <a
                  key={s.id}
                  href={`#${s.id}`}
                  className={cn(
                    "rounded-md px-2 py-1.5 text-slate-500 dark:text-slate-400 transition-colors",
                    "hover:text-slate-900 dark:hover:text-white hover:bg-brand-blue/10"
                  )}
                >
                  {s.title}
                </a>
              ))}
            </CardContent>
          </Card>
        </motion.nav>

        {/* Content */}
        <section className="md:col-span-8 lg:col-span-9 order-1 md:order-2">
          <motion.div
            variants={container}
            initial="hidden"
            animate="show"
            className="flex flex-col gap-6"
          >
            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
              className="bg-white/70 dark:bg-brand-navy/70 backdrop-blur-md rounded-lg"
            >
              <Card id="intro" aria-labelledby="intro-heading">
                <CardHeader>
                  <CardTitle
                    id="intro-heading"
                    className="text-xl flex items-center flex-wrap gap-2"
                  >
                    Welcome to
                    <div className="px-2 py-1 rounded inline-flex items-center">
                      <Image
                        src={"https://knowbuildwebsiteassets.s3.ap-south-1.amazonaws.com/logo.svg"}
                        width={110}
                        height={50}
                        alt="knowbuild_logo_privacy_policy_page"
                        className="inline-block h-6 w-auto"
                      />
                    </div>
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-4">
                    Welcome to KnowBuild (&quot;we,&quot; &quot;our,&quot; or
                    &quot;us&quot;). KnowBuild is operated by KNOWBUILD BUSINESS
                    SOFTWARE PRIVATE LIMITED. This Privacy Policy explains how we
                    collect, use, store, and protect your information when you
                    use our website, software platform, or related services
                    (collectively, &quot;Services&quot;). By accessing or using
                    KnowBuild, you agree to the practices described in this
                    Privacy Policy.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="info-we-collect" aria-labelledby="info-heading">
                <CardHeader>
                  <CardTitle id="info-heading" className="text-xl">
                    1. Information We Collect
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-3">
                    We collect only the information necessary to provide and
                    improve our Services.
                  </p>
                  <h3 className="mb-2 font-medium">
                    1.1 Information You Provide
                  </h3>
                  <ul className="mb-4 list-disc pl-5">
                    <li className="mb-2">
                      <span className="font-medium">
                        Business and Contact Information:
                      </span>{" "}
                      name, email address, phone number, company name,
                      designation, and billing details shared when you sign up,
                      request a demo, or contact us.
                    </li>
                    <li className="mb-2">
                      <span className="font-medium">Account Data:</span> login
                      credentials, user role, and permissions for using
                      KnowBuild.
                    </li>
                    <li>
                      <span className="font-medium">
                        Support Communication:
                      </span>{" "}
                      messages or files shared with our customer support or
                      onboarding teams.
                    </li>
                  </ul>

                  <h3 className="mb-2 font-medium">
                    1.2 Automatically Collected Information
                  </h3>
                  <ul className="mb-4 list-disc pl-5">
                    <li className="mb-2">
                      Browser type, operating system, IP address, device
                      identifiers, and access timestamps.
                    </li>
                    <li className="mb-2">
                      Usage metrics such as module activity, frequency of
                      logins, and system interactions.
                    </li>
                  </ul>
                  <p>
                    We use cookies and analytics tools only to improve product
                    performance, not for third-party advertising.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="use-of-information" aria-labelledby="use-heading">
                <CardHeader>
                  <CardTitle id="use-heading" className="text-xl">
                    2. Purpose and Use of Information
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-3">
                    We process personal data only for legitimate, lawful
                    purposes, including:
                  </p>
                  <ol className="mb-4 list-decimal pl-5">
                    <li className="mb-1">
                      To register and manage user accounts.
                    </li>
                    <li className="mb-1">
                      To provide access to modules and system functionality.
                    </li>
                    <li className="mb-1">
                      To improve our Services and user experience.
                    </li>
                    <li className="mb-1">
                      To communicate updates, service notices, and support
                      information.
                    </li>
                    <li>To comply with legal obligations under Indian law.</li>
                  </ol>
                  <p className="font-medium">
                    We do not sell or rent your personal data to any third
                    party.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="data-retention" aria-labelledby="retention-heading">
                <CardHeader>
                  <CardTitle id="retention-heading" className="text-xl">
                    3. Data Retention
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-3">
                    We retain user and business data only as long as necessary
                    to:
                  </p>
                  <ul className="mb-4 list-disc pl-5">
                    <li className="mb-1">Provide our Services;</li>
                    <li className="mb-1">
                      Fulfil legal and contractual requirements; and
                    </li>
                    <li>Resolve disputes or enforce agreements.</li>
                  </ul>
                  <p>
                    Inactive accounts may be archived or deleted after 24 to 36
                    months of inactivity, following due notice.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="data-sharing" aria-labelledby="sharing-heading">
                <CardHeader>
                  <CardTitle id="sharing-heading" className="text-xl">
                    4. Data Sharing and Disclosure
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-3">
                    Your information may be shared only with:
                  </p>
                  <ul className="mb-4 list-disc pl-5">
                    <li className="mb-1">
                      Authorized employees and partners who require access to
                      perform their roles.
                    </li>
                    <li className="mb-1">
                      Cloud infrastructure providers that host our Services on
                      secure Indian data centres (or equivalent jurisdictions
                      ensuring adequate protection).
                    </li>
                    <li>
                      Regulatory authorities when required by applicable law.
                    </li>
                  </ul>
                  <p>
                    All such entities are bound by confidentiality and security
                    obligations.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="security-practices" aria-labelledby="security-heading">
                <CardHeader>
                  <CardTitle id="security-heading" className="text-xl">
                    5. Security Practices
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-3">
                    We implement reasonable security practices as per Rule 8 of
                    the IT (SPDI) Rules, 2011, including:
                  </p>
                  <ul className="mb-4 list-disc pl-5">
                    <li className="mb-1">
                      Encryption of data in transit and at rest.
                    </li>
                    <li className="mb-1">
                      Multi-factor authentication and role-based access control.
                    </li>
                    <li>Regular audits and backups.</li>
                  </ul>
                  <p>
                    If a data breach occurs, we will notify affected users and
                    authorities within a reasonable time as required by the DPDP
                    Act, 2023.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="user-rights" aria-labelledby="rights-heading">
                <CardHeader>
                  <CardTitle id="rights-heading" className="text-xl">
                    6. User Rights
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-3">
                    Under the Digital Personal Data Protection Act, 2023, you
                    have the right to:
                  </p>
                  <ol className="mb-4 list-decimal pl-5">
                    <li className="mb-1">
                      Access and review your personal data.
                    </li>
                    <li className="mb-1">
                      Correct or update inaccurate information.
                    </li>
                    <li className="mb-1">
                      Withdraw consent (where processing is based on consent).
                    </li>
                    <li>
                      Request deletion of your data, subject to legal
                      obligations.
                    </li>
                  </ol>
                  <p>
                    Requests may be sent to{" "}
                    <a
                      href="mailto:privacy@knowbuild.com"
                      className="underline underline-offset-4 hover:text-slate-900 dark:hover:text-white text-brand-blue"
                    >
                      privacy@knowbuild.com
                    </a>
                    .
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="grievance-officer" aria-labelledby="grievance-heading">
                <CardHeader>
                  <CardTitle id="grievance-heading" className="text-xl">
                    7. Grievance Officer
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p className="mb-4">
                    In compliance with Indian data protection laws, KnowBuild
                    has appointed the following Grievance Officer:
                  </p>
                  <div className="rounded-md bg-slate-100 dark:bg-slate-800 p-4 text-sm">
                    <p className="mb-1">
                      <span className="font-medium">Name:</span> xyz
                    </p>
                    <p className="mb-1">
                      <span className="font-medium">Designation:</span>{" "}
                      Grievance Officer, KnowBuild
                    </p>
                    <p className="mb-1">
                      <span className="font-medium">Email:</span>{" "}
                      <a
                        href="mailto:privacy@knowbuild.com"
                        className="underline underline-offset-4 hover:text-slate-900 dark:hover:text-white text-brand-blue"
                      >
                        privacy@knowbuild.com
                      </a>
                    </p>
                    <p className="mb-1">
                      <span className="font-medium">Address:</span> KnowBuild
                      Business Software Private Limited.
                    </p>
                    <p>New Delhi, India – 110020</p>
                  </div>
                  <p className="mt-4">
                    We will acknowledge and respond to complaints within 15
                    business days.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="policy-updates" aria-labelledby="updates-heading">
                <CardHeader>
                  <CardTitle id="updates-heading" className="text-xl">
                    8. Policy Updates
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    We may update this Privacy Policy from time to time. The
                    latest version will always be available at{" "}
                    <a
                      href="https://www.knowbuild.com/privacy-policy"
                      target="_blank"
                      rel="noopener noreferrer"
                      className="underline underline-offset-4 hover:text-slate-900 dark:hover:text-white text-brand-blue"
                    >
                      www.knowbuild.com/privacy-policy
                    </a>
                    , and the effective date will be revised accordingly.
                  </p>
                </CardContent>
              </Card>
            </motion.div>

            <motion.div
              variants={item}
              transition={{ duration: 0.36, ease: "easeOut" }}
            >
              <Card id="contact" aria-labelledby="contact-heading">
                <CardHeader>
                  <CardTitle id="contact-heading" className="text-xl">
                    9. Contact
                  </CardTitle>
                </CardHeader>
                <CardContent className="leading-relaxed text-sm md:text-base text-pretty">
                  <p>
                    For any questions, reach us at{" "}
                    <a
                      href="mailto:privacy@knowbuild.com"
                      className="underline underline-offset-4 hover:text-slate-900 dark:hover:text-white text-brand-blue"
                    >
                      privacy@knowbuild.com
                    </a>{" "}
                    or through our website's contact form.
                  </p>
                </CardContent>
              </Card>
            </motion.div>
            <div className="flex justify-end w-full">
              <Button
                className="mt-2 w-fit"
                onClick={(e) => {
                  e.preventDefault();
                  document.getElementById('intro')?.scrollIntoView({ behavior: 'smooth' });
                  window.history.replaceState(null, '', '#intro');
                }}
              >
                <span>
                  <ArrowUp className="mr-2 h-4 w-4" />
                </span>
                Back to top
              </Button>
            </div>
          </motion.div>
        </section>
      </div>
    </div>
  );
}
