/**
 * EXAMPLE: How to update PricingPageContent.tsx with zoom-aware utilities
 * 
 * This file shows examples of the changes you can make to handle 150% zoom better.
 * Apply these patterns throughout your components.
 */

'use client';

/**
 * NOTE:
 * This file is intentionally **not** a React component.
 * It exists as a reference for snippets/patterns.
 *
 * Because `.tsx` files are type-checked during `next build`,
 * any raw JSX here must be wrapped or stored as text.
 */
export const PRICING_PAGE_CONTENT_EXAMPLES = `
Example 1: Update the main heading to use fluid typography

BEFORE:
<h1 className="text-5xl md:text-7xl font-bold text-brand-navy dark:text-white mb-6">

AFTER:
<h1 className="text-fluid-4xl md:text-fluid-6xl lg:text-fluid-7xl font-bold text-brand-navy dark:text-white mb-6">
  Pricing
</h1>

Example 2: Update spacing to use fluid values

BEFORE:
<section className="relative pt-40 pb-20 md:pt-48 md:pb-32 bg-slate-50 dark:bg-[#0B1220]">

AFTER:
<section className="relative pt-fluid-2xl pb-fluid-xl md:pt-[clamp(8rem,6rem+10vw,12rem)] md:pb-[clamp(6rem,4rem+8vw,8rem)] bg-slate-50 dark:bg-[#0B1220]">

Example 3: Update padding to use fluid spacing

BEFORE:
<div className="p-8 md:p-10 min-h-full flex flex-col justify-between">

AFTER:
<div className="p-fluid-lg md:p-fluid-xl min-h-full flex flex-col justify-between">

Example 4: Update grid gaps to use fluid spacing

BEFORE:
<div className="grid md:grid-cols-2 gap-8">

AFTER:
<div className="grid md:grid-cols-2 zoom-md:grid-cols-2 gap-fluid-lg">

Example 5: Update text sizes to use fluid typography

BEFORE:
<span className="text-4xl md:text-5xl font-bold text-brand-navy dark:text-white">

AFTER:
<span className="text-fluid-3xl md:text-fluid-4xl font-bold text-brand-navy dark:text-white">

Example 6: Wrap complex layouts in ZoomAwareContainer

<ZoomAwareContainer className="max-w-7xl mx-auto px-fluid-md sm:px-fluid-lg lg:px-fluid-xl">
  <div className="grid grid-cols-1 md:grid-cols-2 gap-fluid-lg">
    {/* Content */}
  </div>
</ZoomAwareContainer>
`;

