import AccordionCommon from "@/components/common-accordion/common-accordion";
import { KnowmoreCommonButtons } from "@/components/common-knowbuild-knowmore/knowmore-buttons";
import { TextComponent } from "@/components/custom-components/TextComponent/TextComponent";
import { ChapterGridForUsecases } from "@/components/GradientBGwithCard/ChapterGrid";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/Button";

import { getMetadata } from "@/lib/metadata";

const UseCasePage = () => {
  return (
    <section className="relative pt-40 pb-20 md:pt-48 md:pb-32 bg-slate-50 dark:bg-[#0B1220] min-h-screen">
      <div className="md:container mx-auto mt-8 relative">
        <div className="space-y-7 mb-16">
          <div className="w-full h-fit flex justify-center">
            <Badge className="uppercase">The knowbuild mindset</Badge>
          </div>
          <div className="space-y-10 mx-auto lg:w-full">
            <div>
              <TextComponent>Every growing SME faces the same challenge — how to scale ?</TextComponent>
              <p className="text-center mt-4 w-full md:w-[50%] mx-auto">
                In this series, Rajat Nagrath, Architect of KnowBuild, reflects on leadership, structure, and the
                strategies that help small and medium businesses grow with clarity and confidence.
              </p>
            </div>
            <div>
              <p className="text-center mt-4 w-full md:w-[50%] mx-auto">
                Chapters from the Architect’s Journal Watch reflections on leadership, innovation, and building
                sustainable organizations. While every business has unique demands, think of these videos as a mirror –
                reflect on them, uncover insights, and challenge yourself to think critically about your next steps for
                growth.
              </p>
            </div>
          </div>
        </div>

        {/* card with bg gradient */}
        <div className="my-16 md:container mx-auto relative">
          <ChapterGridForUsecases />
        </div>

        <div className="flex justify-center my-6">
          <Button size={"lg"} className="text-sm">
            Load More
          </Button>
        </div>

        <div className="my-16">
          <div className="my-16">
            <TextComponent className="">
              Knowbuild: Your smart assistant for seamless workflow integration and scalable growth.
            </TextComponent>
          </div>
          <AccordionCommon />
        </div>

        <div className="my-16 md:my-20 lg:my-32">
          <KnowmoreCommonButtons />
        </div>
      </div>
    </section>
  );
};

export default UseCasePage;

export async function generateMetadata() {
  return getMetadata({
    title: "Knowbuild - Narrative",
    description: "Knowbuild is a platform that helps you build your sales and skills in a structured way.",
  });
}


