import type { Metadata } from 'next';
import { ContactPageContent } from './ContactPageContent';
import { seoConfig } from '../../utils/seo-config';

export const metadata: Metadata = {
  title: seoConfig.contact.title,
  description: seoConfig.contact.description,
  alternates: {
    canonical: `https://knowbuild.com${seoConfig.contact.url}`,
  },
  openGraph: {
    title: seoConfig.contact.title,
    description: seoConfig.contact.description,
    url: `https://knowbuild.com${seoConfig.contact.url}`,
    siteName: 'knowbuild',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: seoConfig.contact.title,
    description: seoConfig.contact.description,
  },
};

export default function ContactPage() {
  return <ContactPageContent />;
}


























