# 🍅 Interactive Timer Implementation

## Overview

The integrated pomo-cli now features a **fully interactive terminal UI** that matches the original [kevinschoon/pomo](https://github.com/kevinschoon/pomo) experience, with additional enhancements.

## What's New

### ✨ Interactive Terminal UI

When you run `pomo-cli start <task-id>`, the CLI opens a **dedicated terminal interface** that displays:

1. **Real-time Countdown Timer**
   - Updates every 100ms for smooth display
   - Shows minutes and seconds (MM:SS format)
   - Large, easy-to-read display

2. **Visual Progress Bar**
   - Animated progress indicator
   - Shows percentage completion
   - Color-coded: Green (█) for progress, Gray (░) for remaining

3. **Task Information**
   - Task name/message
   - Associated tags
   - Pomodoro progress (e.g., "1/4 pomodoros")

4. **State Indicators**
   - ▶ RUNNING (Green) - Timer is active
   - ⏸ PAUSED (Red) - Timer is paused
   - ☕ BREAK TIME (Yellow) - In break mode

5. **Keyboard Controls**
   - Always visible at the bottom
   - Responsive and intuitive

## UI States

### 1. Running State (Green)
```
  🍅 POMODORO TIMER

  Task: Write documentation
  Tags: work, docs

  Progress: 1/4 pomodoros

  24:35

  ▶  RUNNING

  [████████████████████░░░░░░░░░░░░░░░░░░░░] 45%

  Controls:
    [Space/P] Pause/Resume
    [S]       Stop and complete
    [Q]       Quit
```

### 2. Paused State (Red)
```
  🍅 POMODORO TIMER

  Task: Write documentation

  Progress: 1/4 pomodoros

  24:35

  ⏸  PAUSED

  [████████████████████░░░░░░░░░░░░░░░░░░░░] 45%

  Controls:
    [Space/P] Pause/Resume
    [S]       Stop and complete
    [Q]       Quit
```

### 3. Break Time (Yellow)
```
  🍅 POMODORO TIMER

  Task: Write documentation

  Progress: 1/4 pomodoros

  04:52

  ☕ BREAK TIME

  [████████░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░] 20%

  Controls:
    [Space/P] Pause/Resume
    [S]       Stop and complete
    [Q]       Quit
```

## Features

### ⌨️ Keyboard Controls

| Key | Action | Description |
|-----|--------|-------------|
| `Space` | Pause/Resume | Toggle between running and paused states |
| `P` or `p` | Pause/Resume | Alternative pause/resume key |
| `S` or `s` | Stop & Complete | Immediately complete the current session |
| `Q` or `q` | Quit | Exit the timer (session remains incomplete) |
| `Ctrl+C` | Force Quit | Emergency exit with cleanup |

### 🔔 Desktop Notifications

The timer sends system notifications at key moments:

1. **Pomodoro Complete**
   - Title: "Pomodoro Complete"
   - Message: "Time for a break!"
   - Duration: 5 seconds

2. **Break Started**
   - Title: "Break Started"
   - Message: "Relax for 5/15 minutes"
   - Duration: 5 seconds

3. **Break Complete**
   - Title: "Break Complete"
   - Message: "Ready for another pomodoro?"
   - Duration: 5 seconds

**Requirements**: Uses `notify-send` on Linux. Gracefully degrades if not available.

### ⏱️ Break Management

Following the Pomodoro Technique:

- **Short Breaks**: 5 minutes
  - After pomodoros 1, 2, 3
  - Quick refresh period

- **Long Breaks**: 15 minutes
  - After every 4th pomodoro
  - Extended rest period

**Workflow:**
```
Pomodoro 1 (25m) → Short Break (5m) →
Pomodoro 2 (25m) → Short Break (5m) →
Pomodoro 3 (25m) → Short Break (5m) →
Pomodoro 4 (25m) → Long Break (15m) →
[Cycle repeats]
```

### 🎨 Color Coding

Colors indicate the timer state at a glance:

- **Green**: Active/Running - Focus time!
- **Yellow**: Break time - Relax and recharge
- **Red**: Paused - Timer is frozen
- **Cyan**: Header/Title - Visual organization

### 📊 Progress Tracking

Multiple progress indicators:

1. **Pomodoro Counter**: Shows completed vs total (e.g., "2/4")
2. **Progress Bar**: Visual representation with percentage
3. **Time Remaining**: Precise countdown in MM:SS
4. **Session History**: Stored in database for later review

## Technical Details

### Screen Management

- **Clear Screen**: ANSI escape sequence `\033[2J`
- **Cursor Positioning**: `\033[H` moves to top-left
- **Cursor Visibility**: Hidden during timer, restored on exit
- **No Flicker**: Updates only changed content

### Input Handling

- **Non-blocking**: Uses goroutine for keyboard input
- **Raw Mode**: Reads single keypresses without Enter
- **Terminal State**: Properly restored on exit
- **Signal Handling**: Catches Ctrl+C for cleanup

### Update Frequency

- **Timer Tick**: 100ms for smooth updates
- **Display Update**: Every tick (10 times per second)
- **Time Accuracy**: High precision using `time.Duration`

### Database Integration

Sessions are automatically saved to SQLite:
- Start time recorded on session creation
- End time recorded on completion
- Duration tracked even if paused
- Notes can be added after completion

## Usage Examples

### Basic Usage

```bash
# Add a task
pomo-cli add "Write code" -p 4 -d 25m -t "development"

# Start the interactive timer
pomo-cli start 1
```

### Custom Durations

```bash
# Short 15-minute pomodoro
pomo-cli add "Quick task" -p 1 -d 15m

# Extended 50-minute deep work
pomo-cli add "Deep work" -p 1 -d 50m

# Start either
pomo-cli start 1
```

### During Timer

```
1. Press Space to pause (take an urgent call)
2. Press Space again to resume
3. Press S to complete early if task is done
4. Press Q to quit without completing
```

### After Completion

```
✓ Pomodoro completed!

Take a short break (5 minutes)

Press any key to start break, or 'q' to quit...
```

## Configuration

### Custom Colors (Optional)

Create `~/.config/pomo/config.json`:

```json
{
  "colors": {
    "work": "higreen",
    "break": "hiyellow",
    "urgent": "hired"
  },
  "dateTimeFmt": "2006-01-02 15:04"
}
```

### Environment Variables

```bash
# Custom database location
export POMO_DB_PATH="$HOME/.local/share/pomo/pomo.db"

# Custom config location
export POMO_CONFIG_PATH="$HOME/.config/pomo/config.json"

# API server for sync
export POMO_API_URL="http://localhost:3000"
```

## Testing

### Quick Test (1-minute timer)

```bash
# Run the demo script
./demo-timer.sh
```

The script will:
1. Initialize the database
2. Create a 1-minute test task
3. Start the interactive timer
4. Let you test all keyboard controls

### Integration Testing

```bash
# Run full integration tests
./test-integration.sh
```

## Comparison with Original Pomo

| Feature | Original | Integrated | Notes |
|---------|----------|------------|-------|
| Interactive UI | ✅ | ✅ | Same experience |
| Real-time Updates | ✅ | ✅ | 100ms refresh |
| Pause/Resume | ✅ | ✅ | Space key added |
| Desktop Notifications | ✅ | ✅ | notify-send |
| Break Management | ✅ | ✅ | 5min + 15min |
| Progress Bar | ❌ | ✅ | **New!** |
| Database Persistence | ❌ | ✅ | **New!** |
| Task Metadata | Limited | ✅ | Enhanced |
| API Sync | ❌ | ✅ | **New!** |

## Troubleshooting

### Notifications Not Working

```bash
# Install notify-send (Ubuntu/Debian)
sudo apt install libnotify-bin

# Install notify-send (Arch)
sudo pacman -S libnotify

# Test notification
notify-send "Test" "This is a test"
```

### Terminal Display Issues

```bash
# Reset terminal if corrupted
reset

# Or use tput
tput reset
```

### Keyboard Input Not Responding

The timer uses raw terminal mode. If something goes wrong:

```bash
# Restore normal terminal settings
stty sane

# Or explicitly
stty echo
```

## Future Enhancements

🔜 **Planned Features:**
- Sound alerts (optional beep/chime)
- Session statistics in UI
- Custom break durations
- Timer presets
- Multiple concurrent timers
- Themes/color schemes

## Credits

- Original pomo CLI: [kevinschoon/pomo](https://github.com/kevinschoon/pomo)
- Pomodoro Technique: Francesco Cirillo
- Terminal colors: [fatih/color](https://github.com/fatih/color)

---

**Happy focusing! 🍅**


