#!/bin/bash

# Deployment Script for Pomo App
# Usage: ./deploy.sh

set -e

# Colors
GREEN='\033[0;32m'
BLUE='\033[0;34m'
NC='\033[0m'

echo -e "${BLUE}🍅 Starting Pomo App Deployment...${NC}"

# Check for .env file
if [ ! -f .env ]; then
    echo "Creating .env file from example..."
    echo "JWT_SECRET=$(openssl rand -hex 32)" >> .env
    echo "TELEGRAM_BOT_TOKEN=your_bot_token_here" >> .env
    echo -e "${GREEN}Created .env file. Please edit it with your real Telegram Bot Token!${NC}"
fi

# Build and Start Containers
echo -e "${BLUE}Building and starting containers...${NC}"
docker compose up -d --build

echo -e "${GREEN}✅ Deployment Complete!${NC}"
echo -e "API is running on port 3000"
echo -e "Bot is running in background"
echo -e ""
echo -e "Next Steps:"
echo -e "1. Edit .env and set your TELEGRAM_BOT_TOKEN"
echo -e "2. Restart containers: docker compose restart"
echo -e "3. Configure your local CLI to point to this server"
